//+------------------------------------------------------------------+
//|     Filename changed to ForexOFFTrend.mq4 by CrazyChart & Lukas1 |
//|                         SilverBank .mq4                          |
//|                         SilverBank changed by CrazyChart & Lukas1|
//|     For 15 min & more long.        idea from     http://viac.ru/ |
//+------------------------------------------------------------------+
//. bank - : , ; ; ; ; , ;
//             ;   ;     [.] 
//

#property copyright "SilverTrend rewritten by CrazyChart"
#property link "http://viac.ru/ "
//----
#property indicator_chart_window
#property indicator_buffers 4
#property indicator_color1 Blue
#property indicator_color2 Red
#property indicator_color3 Aqua
#property indicator_color4 Violet
//---- input parameters
extern int CountBars = 5400;
extern int SSP       =   21;
extern int Delta     =    3;
extern double Kmin   =  1.6;
extern double Kmax   = 50.6;
extern bool gAlert = false; // Switch to allow alerts
//---- buffers
double ExtMapBuffer1[];
double ExtMapBuffer2[];
double Wal1[];
double Wal2[];
//----
bool gSellAlertGiven = false; // Used to stop constant alerts
bool gBuyAlertGiven  = false; // Used to stop constant alerts
//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
int init()
  {
//---- indicators
   IndicatorBuffers(4);
   SetIndexStyle(0, DRAW_LINE, 0, 2);
   SetIndexBuffer(0, ExtMapBuffer1);
   SetIndexStyle(1, DRAW_LINE, 0, 2);
   SetIndexBuffer(1, ExtMapBuffer2);

   SetIndexStyle(2,DRAW_ARROW);
   SetIndexArrow(2,233);
   SetIndexStyle(3,DRAW_ARROW);
   SetIndexArrow(3,234);
   SetIndexBuffer(2,Wal1);
   SetIndexBuffer(3,Wal2);



//----
   if(CountBars >= Bars)
       CountBars = Bars;
   SetIndexDrawBegin(0, Bars - CountBars + SSP);
   SetIndexDrawBegin(1, Bars - CountBars + SSP);
//----
   return(0);
  }
//+------------------------------------------------------------------+
//| Custor indicator deinitialization function                       |
//+------------------------------------------------------------------+
int deinit()
  {
   return(0);
  }
//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int start()
  {
   int i, i1,  i2, shift,  loopbegin,   counted_bars = IndicatorCounted();
   double SsMax,   SsMin,   K,   val1,   val2,   smin,   smax,   price;
   double Range,  AvgRange;
   bool uptrend,old;
   if(Bars <= SSP + 1)
       return(0);
//---- initial zero
   if(counted_bars < SSP + 1)
     {
       for(i = 1; i <= SSP; i++) ExtMapBuffer1[CountBars-i] = 0.0;
       for(i = 1; i <= SSP; i++) ExtMapBuffer2[CountBars-i] = 0.0;
       for(i = 1; i <= SSP; i++)   Wal1[CountBars-i]        = 0.0;
       for(i = 1; i <= SSP; i++)   Wal2[CountBars-i]        = 0.0;

     }
   for(i = CountBars - SSP; i >= 0; i--) //  
     {
      Range=0;
	   AvgRange=0;
	for (i1=shift; i1<=shift+SSP; i1++)
		{AvgRange=AvgRange+MathAbs(High[i1]-Low[i1]);}

	Range=AvgRange/(SSP+1);
       SsMax = High[Highest(NULL, 0, MODE_HIGH, SSP, i - SSP + 1)];
       SsMin = Low[Lowest(  NULL, 0, MODE_LOW,  SSP, i - SSP + 1)];
   for (i2=shift;i2<=shift+SSP-1;i2++)
        {
         price=High[i2];
         price=Low[i2];
        }
       smin = NormalizeDouble((SsMin - (SsMax - SsMin)*Kmin / 100), 6);
       smax = NormalizeDouble((SsMax - (SsMax - SsMin)*Kmax / 100), 6);
       ExtMapBuffer1[i-SSP+6] = smax;
       ExtMapBuffer2[i-SSP-1] = smax;
       val1 = ExtMapBuffer1[i-1];
       val2 = ExtMapBuffer2[i-1];
	    Wal1[shift]=0;
	    Wal2[shift]=0;
	if (Close[shift]<smin)
		{
		uptrend = false;
		}
	if (Close[shift]>smax)
		{
		uptrend = true;
		}
   if (uptrend!=old && uptrend==true) {Wal1[shift]=Low[shift]-Range*0.5;}
   if (uptrend!=old && uptrend==false) {Wal2[shift]=High[shift]+Range*0.5;}
   old=uptrend;

       if(val1 > val2+Delta*Point)
         {
          Wal1[i]=val1;
         }
       if(val1 < val2-Delta*Point)
         {
          Wal2[i]=val2;
         }
     }
//----
   return(0);
  }
//+------------------------------------------------------------------+ 